/*
 * Decompiled with CFR 0.152.
 */
package com.sec.sdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static Map<String, Object> toMap(String jsonBody) {
        Map<String, Object> jsonMap = new HashMap<String, Object>();
        try {
            jsonMap = (Map)JSON.parseObject((String)jsonBody, (TypeReference)new TypeReference<TreeMap<String, Object>>(){}, (Feature[])new Feature[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonMap;
    }

    public static <T> T toObject(String jsonBody, Class<T> jsonClazz) {
        if (StringUtils.isBlank((CharSequence)jsonBody)) {
            return null;
        }
        try {
            return (T)JSON.parseObject((String)jsonBody, jsonClazz);
        }
        catch (Throwable ignored) {
            logger.error("Json Object Convert To Failed,jsonString:" + jsonBody, ignored);
            return null;
        }
    }

    public static <T> List<T> toListObject(String jsonBody, Class<T> jsonClazz) {
        if (StringUtils.isBlank((CharSequence)jsonBody)) {
            return null;
        }
        try {
            return JSON.parseArray((String)jsonBody, jsonClazz);
        }
        catch (Throwable ex) {
            logger.error("Json Object Convert To Failed,jsonString:" + jsonBody, ex);
            return null;
        }
    }

    public static String ObjectTojson(Object obj) {
        return JSON.toJSONString((Object)obj);
    }
}

