/*
 * Decompiled with CFR 0.152.
 */
package com.sec.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.sec.sdk.bean.BaseRequestDTO;
import com.sec.sdk.bean.BaseResponse;
import com.sec.sdk.bean.BusinessResponse;
import com.sec.sdk.bean.NewBaseRequestDTO;
import com.sec.sdk.exception.SecGatewayException;
import com.sec.sdk.utils.JsonUtils;
import com.sec.sdk.utils.SecSignature;
import com.sec.sdk.utils.WebUtils;
import com.sec.sdk.utils.codec.AESUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecClient {
    private static final Logger log = LoggerFactory.getLogger(SecClient.class);
    private String serverUrl;
    private String appId;
    private String merPrivateKey;
    private String method;
    private String signType = "RSA2";
    private String version = "1.0";
    private String charset = "UTF-8";
    private String timestamp;
    private String merchantRequestNo;
    private int connectTimeout;
    private int readTimeout;

    public SecClient(String serverUrl, String method, String appId, String merPrivateKey, String merchantRequestNo, String timestamp, int connectTimeout, int readTimeout) {
        this.serverUrl = serverUrl;
        this.method = method;
        this.appId = appId;
        this.merPrivateKey = merPrivateKey;
        this.merchantRequestNo = merchantRequestNo;
        this.timestamp = timestamp;
        if (connectTimeout > 20000) {
            this.connectTimeout = connectTimeout;
        }
        if (readTimeout > 20000) {
            this.readTimeout = readTimeout;
        }
    }

    public SecClient(String serverUrl, String appId, String merPrivateKey, String merchantRequestNo, String timestamp, int connectTimeout, int readTimeout) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.merPrivateKey = merPrivateKey;
        this.merchantRequestNo = merchantRequestNo;
        this.timestamp = timestamp;
        if (connectTimeout > 20000) {
            this.connectTimeout = connectTimeout;
        }
        if (readTimeout > 20000) {
            this.readTimeout = readTimeout;
        }
    }

    @Deprecated
    public BaseResponse excute(BaseRequestDTO bizContent) throws SecGatewayException, IOException {
        Map<String, String> params = this.buildParams(this.method, JsonUtils.ObjectTojson(bizContent));
        String signa = SecSignature.rsaSign(params, this.merPrivateKey, this.charset, this.signType);
        params.put("sign", signa);
        String resp = WebUtils.doPost(this.serverUrl, params, this.charset, this.connectTimeout, this.readTimeout, null, 0);
        return JsonUtils.toObject(resp, BaseResponse.class);
    }

    public <T extends BusinessResponse> BaseResponse<T> execute(NewBaseRequestDTO newRequest, String method) throws SecGatewayException, IOException {
        if (Objects.isNull(method)) {
            method = newRequest.getMethod();
        }
        if (Objects.isNull(method)) {
            method = this.method;
        }
        Map<String, String> params = this.buildParams(method, JsonUtils.ObjectTojson(newRequest));
        String signa = SecSignature.rsaSign(params, this.merPrivateKey, this.charset, this.signType);
        params.put("sign", signa);
        String resp = WebUtils.doPost(this.serverUrl, params, this.charset, this.connectTimeout, this.readTimeout, null, 0);
        log.debug("serverUrl: {}; response: \n{}", (Object)this.serverUrl, (Object)resp);
        return this.extractBaseResponse(newRequest, resp);
    }

    public <T extends BusinessResponse> BaseResponse<T> encryptExecute(NewBaseRequestDTO newRequest, String ivStr) throws SecGatewayException, IOException {
        byte[] iv = this.validateIv(ivStr);
        String plainJson = JSON.toJSONString((Object)newRequest);
        String encryptedData = this.aesEncrypt(plainJson, iv);
        String finalRequestBody = this.buildFinalRequestBody(encryptedData, iv, newRequest.getMethod());
        String responseBody = WebUtils.doPost(this.serverUrl, finalRequestBody, this.connectTimeout, this.readTimeout);
        return this.extractBaseResponse(newRequest, responseBody);
    }

    private Map<String, String> buildParams(String method, String bizContent) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", this.appId);
        params.put("method", method);
        params.put("sign_type", this.signType);
        params.put("timestamp", this.timestamp);
        params.put("version", this.version);
        params.put("merchant_request_no", this.merchantRequestNo);
        params.put("biz_content", bizContent);
        return params;
    }

    private <T extends BusinessResponse> BaseResponse<T> extractBaseResponse(NewBaseRequestDTO newRequest, String resp) {
        BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)resp, (TypeReference)new TypeReference<BaseResponse<T>>(){}, (Feature[])new Feature[0]);
        if (baseResponse.connectFlag().booleanValue() && Objects.nonNull(baseResponse.getResponse()) && !baseResponse.getResponse().isEmpty()) {
            Class responseClass = newRequest.getResponseClass();
            BusinessResponse businessResponse = (BusinessResponse)JsonUtils.toObject(baseResponse.getResponse(), responseClass);
            baseResponse.setBusinessResponse(businessResponse);
        }
        return baseResponse;
    }

    private byte[] validateIv(String ivStr) throws SecGatewayException {
        byte[] iv = ivStr.getBytes(StandardCharsets.UTF_8);
        if (iv == null || iv.length != 16) {
            throw new SecGatewayException("Invalid IV: must be 16 bytes");
        }
        return iv;
    }

    private String aesEncrypt(String plainText, byte[] iv) throws SecGatewayException {
        try {
            return AESUtil.encrypt(plainText, iv);
        }
        catch (Exception e) {
            throw new SecGatewayException("AES encryption failed", e);
        }
    }

    private String buildFinalRequestBody(String encryptedData, byte[] iv, String methodName) throws SecGatewayException {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("data", encryptedData);
        requestMap.put("iv", new String(iv));
        requestMap.put("app_id", this.appId);
        requestMap.put("method", Objects.isNull(methodName) ? this.method : methodName);
        requestMap.put("timestamp", this.timestamp);
        requestMap.put("version", this.version);
        requestMap.put("merchant_request_no", this.merchantRequestNo);
        return JSON.toJSONString(requestMap);
    }
}

